//---------------------------------------------------------------------------
#include <allegro.h>
#include <stdlib.h>
#include <float.h>
//---------------------------------------------------------------------------
#include "Class_Sprite.h"
#include "Explosao.h"
//---------------------------------------------------------------------------
typedef	struct {
	float xinc;
	float yinc;
	float x1;
	float y1;
	float x2;
	float y2;
	unsigned char status;
} MISSEL;
//---------------------------------------------------------------------------
#define EXPLODE_W 37
#define EXPLODE_H 37
#define	ncometas 100
#define pset(x,y,z) putpixel(doublebuffer,x,y,z)
//---------------------------------------------------------------------------
MISSEL cometa[ncometas];
BITMAP *SKY;
BITMAP *fundo2;
BITMAP *fundo;
BITMAP *mouse;
BITMAP *base[4];
BITMAP *doublebuffer;
PALETTE palette;
int fimc=0;
int pontos=0;
int posnuvem=0;
//---------------------------------------------------------------------------
int bmouse=0;
SAMPLE *sample;
SAMPLE *sample1;
FONT *fonte_legal;
BITMAP *fonte;
BITMAP *logo;
BITMAP *menu;
//---------------------------------------------------------------------------
TExplode *explode;
TExplode *fumaca;
TExplode *fumacap;
TExplode *nuclear;
//---------------------------------------------------------------------------
bool fum=false;
int pfum=0;
int xex,yex;
bool exp=false;
int exp_x,exp_y,exp_i;
int pan;
//---------------------------------------------------------------------------
int FPS=0;
float aFPS=0;
//---------------------------------------------------------------------------
int main();
void init();
void deinit();
BITMAP *loadbmp(char *filename, int transparent);
void inicializa();
void mouseini();
void wait(int ms);
void cometas();
float rnd();
void fogo(int i);
void verifica(int xi, int yi);
//---------------------------------------------------------------------------
volatile int counter=0;
//---------------------------------------------------------------------------
void count()
{
	counter++;
}
END_OF_FUNCTION (Count);
//---------------------------------------------------------------------------
int Clock()
{
	return counter;
}
//---------------------------------------------------------------------------
int main()
{
 	int x,y,i,j,h;
 	int vigia=0;
 	int timea,timeb,timec;
    MIDI *music;
    int temp_ant;
    
	init();
	inicializa();
	mouseini();    

	music = load_midi(".\\musicas\\ini.mid");
	if (!music) {
      allegro_message("Error reading MIDI file \n");
    }
    
	sample = load_sample(".\\sons\\explode.wav");
    if (!sample)
       allegro_message("Couldn't load sample!");
       
    sample1 = load_sample(".\\sons\\fuma.wav");
    if (!sample1)
       allegro_message("Couldn't load sample1!");
		 	
		 	
	logo = loadbmp(".\\imagens\\logo.bmp", TRGB(255,0,255));
	if (!logo)
       allegro_message("Couldn't load sample1!");
    
    menu = loadbmp(".\\imagens\\menu.bmp", TRGB(255,0,255));
	if (!menu)
       allegro_message("Couldn't load sample1!");
       
	set_volume(255,255);
	
	play_midi(music, -1);

	cometas();	
		
	nuclear = new TExplode(".\\imagens\\nuclear.bmp",TRGB(255,0,255),100,78,121);
	fumaca = new TExplode(".\\imagens\\fumaca.bmp",TRGB(0,255,0),80,48,48);
	fumacap = new TExplode(".\\imagens\\fumacap.bmp",TRGB(0,255,0),80,32,32);
	explode = new TExplode(".\\imagens\\explodes.bmp",TRGB(0,255,0),250,37,37);
	
	explode->SetColisao((VER_COLISAO)(verifica));
	//fumacap->SetColisao((VER_COLISAO)(verifica));
	

	timea=Clock();
	timeb=timea;
	timec=timeb;
	

	while (!key[KEY_ESC]) 
	{
		blit(fundo, doublebuffer, 0, 0, 0, 0 , fundo->w, fundo->h);
		
		draw_sprite(doublebuffer, base[0], 287, 322);

		if (mouse_x<212)
			draw_sprite(doublebuffer, base[2], 287, 322);
		
		if(mouse_x>424)
			draw_sprite(doublebuffer, base[3], 287, 322);
		
		if(mouse_x>=212 && mouse_x<=424/* && vigia!=0*/)
			draw_sprite(doublebuffer, base[1], 287, 322);
		
		if((Clock()-timea)>20)
		{
			timea=Clock();
			for(i=0;i<ncometas;i++)
				if(cometa[i].status==0)
				{
					cometa[i].x2+=cometa[i].xinc;
					cometa[i].y2+=cometa[i].yinc;
					
					if(cometa[i].y2>342.0)
					{
						fimc++;
						cometa[i].status=1;
						xex = (int)(cometa[i].x2) - 24;
						yex = (int)(cometa[i].y2) - 24;
						pan=(int)((255.0*cometa[i].x2)/(SCREEN_W));
						
						play_sample(sample1, 128, pan, 1000, 0);
						//textprintf_ex(screen, fonte_legal, 25, 400, makecol(0, 0, 0),makecol(123, 90, 57), " %d", pan);
						//wait(500);
						if((int)(cometa[i].x2)<322||(int)(cometa[i].x2)>366)
							fumaca->AdicionaExplosao(doublebuffer,xex,yex,Clock());
						else
							nuclear->AdicionaExplosao(doublebuffer,xex-15,yex-36,Clock());
						// Animacao Fumaca
						
					}
				}
			if(fimc>=ncometas)
			{
				cometas();
				fimc=0;
			}
		}

		for(i=0;i<ncometas;i++)
			if(cometa[i].status==0)
			{
				fastline(doublebuffer, (int)(cometa[i].x1), (int)(cometa[i].y1), (int)(cometa[i].x2), (int)(cometa[i].y2), makecol(0,0,0));
				//circlefill(doublebuffer,(int)(cometa[i].x2), (int)(cometa[i].y2),1, makecol(0,0,0));
			}

		if ((mouse_b & 1) == 0)
		{
			bmouse=1;
		}
		if ((mouse_b&1)&&bmouse==1)
		{
			bmouse=0;
			exp_x=mouse_x-EXPLODE_W/2;
		   	exp_y=mouse_y-EXPLODE_H/2;
		   	explode->AdicionaExplosao(doublebuffer,exp_x,exp_y,Clock());
		}
		  
		fumacap->DrawExplosao(doublebuffer,Clock());
		explode->DrawExplosao(doublebuffer,Clock());
		fumaca->DrawExplosao(doublebuffer,Clock());
		nuclear->DrawExplosao(doublebuffer,Clock());
		
		
		FPS++;
		
		if(FPS==10)
		{
			FPS=0;	
			aFPS=10000.0/(Clock()-temp_ant);
			textprintf_ex(doublebuffer, fonte_legal, 25, 448,makecol(0, 0, 0),makecol(123, 90, 57), " Pontos: %05d, FPS: %f", pontos,aFPS);
			temp_ant=Clock();
		}
		else
			textprintf_ex(doublebuffer, fonte_legal, 25, 448,makecol(0, 0, 0),makecol(123, 90, 57), " Pontos: %05d, FPS: %f", pontos,aFPS);
		
		
		draw_sprite(doublebuffer, logo, (SCREEN_W/2)-(logo->w/2), 10);
		draw_sprite(doublebuffer, menu, (SCREEN_W/2)-(menu->w/2), (SCREEN_H/2)-(menu->h/2));
		//vsync();
		blit(doublebuffer, screen, 0, 0, 0, 0 , SCREEN_W, SCREEN_H);
		
	}
	stop_midi();
	destroy_sample(sample);
	destroy_midi(music);
	
//	delete sprite;
	delete fumaca;
	delete fumacap;
	delete nuclear;
	delete explode;
    destroy_bitmap(fundo);
    destroy_bitmap(mouse);
//    destroy_bitmap(explode[0]);
//    destroy_bitmap(explode[1]);
//    destroy_bitmap(explode[2]);
//    destroy_bitmap(explode[3]);
    destroy_bitmap(base[0]);
    destroy_bitmap(base[1]);
    destroy_bitmap(base[2]);
    destroy_bitmap(base[3]);
//    destroy_bitmap(buffexplode);
//    destroy_bitmap(buffbase);
    destroy_bitmap(SKY);
    destroy_bitmap(fundo2);
    destroy_font(fonte_legal);
    destroy_bitmap(fonte);
    destroy_bitmap(doublebuffer);

    deinit();
    return 0;
}
END_OF_MAIN()
//---------------------------------------------------------------------------
void init() 
{
	int depth, res;
	allegro_init();
	depth = desktop_color_depth();
	if (depth == 0) depth = 32;
	set_color_depth(depth);
	res = set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0);
	if (res != 0) 
	{
		allegro_message(allegro_error);
		exit(-1);
	}

  	install_timer();
	LOCK_FUNCTION(count);
  	LOCK_VARIABLE(counter);  
	install_int_ex(count, MSEC_TO_TIMER(1));

	install_keyboard();
	if(install_mouse()==-1)
          allegro_message("Couldn't mouse");
    set_window_title("The BUM game");
	/* add other initializations here */
    if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL) != 0) {
      allegro_message("Error initialising sound system\n%s\n", allegro_error);
      exit(-1);
   }
	
}
//---------------------------------------------------------------------------
void deinit() 
{
	clear_keybuf();
	/* add other deinitializations here */
}
//---------------------------------------------------------------------------
void inicializa()
{
	doublebuffer = create_bitmap_ex(32, SCREEN_W, SCREEN_H);
 	if (!doublebuffer)
	   allegro_message("Nao foi possivel criar o doublebuffer bitmap");
	
	fonte = load_bitmap(".\\imagens\\rt.pcx", palette);

 	fonte_legal = load_bitmap_font(".\\imagens\\rt.pcx", palette, NULL);
 	//fonte_legal = grab_font_from_bitmap(fonte);
 	if (!fonte_legal)
		allegro_message("Nao foi possivel ler o bitmap fonte.pcx");
	
	SKY = load_bitmap(".\\imagens\\SKY.bmp", palette);
	if (!SKY)
		allegro_message("Nao foi possivel ler o bitmap fundo.bmp");

	fundo2 = load_bitmap(".\\imagens\\fundo2.bmp", palette);
	if (!fundo2)
		allegro_message("Nao foi possivel ler o bitmap fundo.bmp");
	
	fundo = load_bitmap(".\\imagens\\fundo.bmp", palette);
	if (!fundo)
		allegro_message("Nao foi possivel ler o bitmap fundo.bmp");
		
/*	explode[0]=loadbmp(".\\imagens\\explode0.bmp",makecol(0,255,0));
	if (!explode[0])
		allegro_message("Nao foi possivel ler o bitmap explode0.bmp");
	
	explode[1]=loadbmp(".\\imagens\\explode1.bmp",makecol(0,255,0));
	if (!explode[1])
		allegro_message("Nao foi possivel ler o bitmap explode1.bmp");

	explode[2]=loadbmp(".\\imagens\\explode2.bmp",makecol(0,255,0));
	if (!explode[2])
		allegro_message("Nao foi possivel ler o bitmap explode2.bmp");

	explode[3]=loadbmp(".\\imagens\\explode3.bmp",makecol(0,255,0));
	if (!explode[3])
		allegro_message("Nao foi possivel ler o bitmap explode3.bmp");
*/
	base[0]=loadbmp(".\\imagens\\base.bmp",makecol(0,255,0));
	if (!base[0])
		allegro_message("Nao foi possivel ler o bitmap base.bmp");

	base[1]=loadbmp(".\\imagens\\base90.bmp",makecol(0,255,0));
	if (!base[1])
		allegro_message("Nao foi possivel ler o bitmap base90.bmp");

	base[2]=loadbmp(".\\imagens\\baseE.bmp",makecol(0,255,0));
	if (!base[2])
		allegro_message("Nao foi possivel ler o bitmap baseE.bmp");

	base[3]=loadbmp(".\\imagens\\baseD.bmp",makecol(0,255,0));
	if (!base[3])
		allegro_message("Nao foi possivel ler o bitmap baseD.bmp");

    mouse = loadbmp(".\\imagens\\mouse.bmp", makecol(0,255,0));
    if (!mouse)
	   allegro_message("Nao foi possivel ler o bitmap mouse.bmp");

/*	 buffexplode=create_bitmap(explode[0]->w, explode[0]->h);
	 if(!buffexplode)
        allegro_message("Nao foi possivel criar o bitmap explode");
     clear_to_color(buffexplode, bitmap_mask_color(doublebuffer));
     
	 buffbase=create_bitmap(base[0]->w, base[0]->h);
	 if(!buffbase)
        allegro_message("Nao foi possivel criar o bitmap base");
     clear_to_color(buffbase, bitmap_mask_color(doublebuffer));
*/     
}
//---------------------------------------------------------------------------
void mouseini()
{
	set_mouse_sprite(mouse);
	set_mouse_sprite_focus(7, 7);
	  
    show_mouse(screen);
}
//---------------------------------------------------------------------------
BITMAP *loadbmp(char *filename, int transparent)
{
 	   BITMAP *bmp;
 	   PALETTE palette;
 	   int x,y;
 	   
	   bmp = load_bitmap(filename, palette);
	   if(!bmp)
	   		   return NULL;
      /* Replace mask color with another color. */
      for (y = 0; y < bmp->h; y++)
         for (x = 0; x < bmp->w; x++)
            if (getpixel(bmp, x, y) == transparent)
               putpixel(bmp, x, y, bitmap_mask_color(doublebuffer)); 	 
	   return bmp;
}
//---------------------------------------------------------------------------
void wait(int ms)
 {
  int endwait;

  endwait=Clock()+ms;
  while(Clock()<endwait) {}
}
//---------------------------------------------------------------------------
void cometas()
{
	float f=0.0;
	int i,x,y;
	for(i=0;i<ncometas;i++)
	{
		cometa[i].x2 = rnd() * SCREEN_W;
		x = (int) (rnd() * SCREEN_W - cometa[i].x2);
		y = 342;
		f = rnd() * .001 + .001;
		cometa[i].xinc=(float)x * f;
		cometa[i].yinc=(float)y * f;
		cometa[i].y2=0.0;
		cometa[i].y1=0.0;
		cometa[i].x1 = cometa[i].x2;
		cometa[i].status=0;
	}
}
//---------------------------------------------------------------------------
float rnd()
{
        return (float)((rand() % 10000)+.0001)/10000;
}
//---------------------------------------------------------------------------
void verifica(int xi, int yi)
{
	int xa=0,ya=0,i=0,xf=0,yf=0;

	xf=xi+EXPLODE_W;
	yf=yi+EXPLODE_H;
	
	//rect(doublebuffer, xi, yi, xf-1, yf-1, 0);
	
	for(i=0;i<ncometas;i++)
		{
			xa=(int)(cometa[i].x2);
			ya=(int)(cometa[i].y2);
			if(xa>xi&&xa<xf&&ya>yi&&ya<yf&&cometa[i].status==0)
			{
				cometa[i].status=1;
				fimc++;
				pontos++;

				fumacap->AdicionaExplosao(doublebuffer,xa-16,ya-16,Clock());
				//explode->AdicionaExplosao(doublebuffer,xa-18,ya-18,Clock());
				pan=(int)((255.0*cometa[i].x2)/(SCREEN_W));
				play_sample(sample, 128, pan, 1000, 0);
			}
		}
}
//---------------------------------------------------------------------------
